/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.util;

import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.appbar.AppBarLayout;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.listener.CoordinatorLayoutListener;

public class DesignUtil {
    public static void checkCoordinatorLayout(View content, RefreshKernel kernel, CoordinatorLayoutListener listener) {
        try {
            if (content instanceof CoordinatorLayout) {
                kernel.getRefreshLayout().setEnableNestedScroll(false);
                DesignUtil.wrapperCoordinatorLayout((ViewGroup)content, listener);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void wrapperCoordinatorLayout(ViewGroup layout, final CoordinatorLayoutListener listener) {
        for (int i = layout.getChildCount() - 1; i >= 0; --i) {
            View view = layout.getChildAt(i);
            if (!(view instanceof AppBarLayout)) continue;
            ((AppBarLayout)view).addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){

                public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                    listener.onCoordinatorUpdate(verticalOffset >= 0, appBarLayout.getTotalScrollRange() + verticalOffset <= 0);
                }
            });
        }
    }
}

