/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.adapter;

import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.adapter.SmartViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SmartRecyclerAdapter<T>
extends RecyclerView.Adapter<SmartViewHolder>
implements ListAdapter {
    private final int mLayoutId;
    private final List<T> mList;
    private int mLastPosition = -1;
    private boolean mOpenAnimationEnable = true;
    protected SmartViewHolder.OnItemClickListener mOnItemClickListener;
    protected SmartViewHolder.OnItemLongClickListener mOnItemLongClickListener;
    private final DataSetObservable mDataSetObservable = new DataSetObservable();

    public SmartRecyclerAdapter(@LayoutRes int layoutId) {
        this.setHasStableIds(false);
        this.mList = new ArrayList<T>();
        this.mLayoutId = layoutId;
    }

    public SmartRecyclerAdapter(Collection<T> collection, @LayoutRes int layoutId) {
        this.setHasStableIds(false);
        this.mList = new ArrayList<T>(collection);
        this.mLayoutId = layoutId;
    }

    public SmartRecyclerAdapter(Collection<T> collection, @LayoutRes int layoutId, SmartViewHolder.OnItemClickListener listener) {
        this.setHasStableIds(false);
        this.setOnItemClickListener(listener);
        this.mList = new ArrayList<T>(collection);
        this.mLayoutId = layoutId;
    }

    private void addAnimate(SmartViewHolder holder, int position) {
        if (this.mOpenAnimationEnable && this.mLastPosition < position) {
            holder.itemView.setAlpha(0.0f);
            holder.itemView.animate().alpha(1.0f).start();
            this.mLastPosition = position;
        }
    }

    public SmartViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new SmartViewHolder(this.generateItemView(parent, viewType), this.mOnItemClickListener, this.mOnItemLongClickListener);
    }

    protected View generateItemView(ViewGroup parent, int viewType) {
        return this.getInflate(parent, this.mLayoutId);
    }

    protected View getInflate(ViewGroup parent, @LayoutRes int layoutId) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
    }

    public void onBindViewHolder(SmartViewHolder holder, int position) {
        if (this.getItem(position) != null) {
            this.onBindViewHolder(holder, this.getItem(position), position);
        }
    }

    protected abstract void onBindViewHolder(SmartViewHolder var1, T var2, int var3);

    public int getItemCount() {
        return this.mList.size();
    }

    public void onViewAttachedToWindow(SmartViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        this.addAnimate(holder, holder.getLayoutPosition());
    }

    public void setOpenAnimationEnable(boolean enabled) {
        this.mOpenAnimationEnable = enabled;
    }

    public SmartRecyclerAdapter<T> setOnItemClickListener(SmartViewHolder.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    public SmartRecyclerAdapter<T> setOnItemLongClickListener(SmartViewHolder.OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
        return this;
    }

    public SmartRecyclerAdapter<T> refresh(Collection<T> collection) {
        if (collection != null) {
            this.mList.clear();
            this.mList.addAll(collection);
            this.notifyChanged();
            this.mLastPosition = -1;
        }
        return this;
    }

    public SmartRecyclerAdapter<T> loadMore(Collection<T> collection) {
        if (collection != null) {
            this.mList.addAll(collection);
            this.notifyChanged();
        }
        return this;
    }

    public SmartRecyclerAdapter<T> load(T item) {
        if (item != null) {
            this.mList.add(item);
            this.notifyChanged();
        }
        return this;
    }

    private void notifyChanged() {
        this.notifyDataSetChanged();
        this.notifyListDataSetChanged();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public void notifyListDataSetChanged() {
        this.mDataSetObservable.notifyChanged();
    }

    public void notifyDataSetInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        SmartViewHolder holder;
        if (convertView != null) {
            holder = (SmartViewHolder)((Object)convertView.getTag());
        } else {
            holder = this.onCreateViewHolder(parent, this.getItemViewType(position));
            convertView = holder.itemView;
            convertView.setTag((Object)holder);
        }
        holder.setPosition(position);
        this.onBindViewHolder(holder, position);
        this.addAnimate(holder, position);
        return convertView;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public T getItem(int position) {
        return position < this.getCount() ? (T)this.mList.get(position) : null;
    }

    public int getCount() {
        return this.mList != null ? this.mList.size() : 0;
    }

    public void replace(int position, T item) {
        if (position > -1 && position < this.mList.size() && item != null) {
            this.mList.set(position, item);
            this.notifyDataSetChanged();
        }
    }

    public void replaceNotNotify(int position, T item) {
        if (position > -1 && position < this.mList.size() && item != null) {
            this.mList.set(position, item);
        }
    }

    public List<T> getListData() {
        return this.mList;
    }

    public int getLastPosition() {
        return this.mLastPosition;
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.mList.clear();
        }
    }
}

