/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.adapter;

import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseRecyclerAdapter<T, V extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<V>
implements ListAdapter {
    private final List<T> mList;
    private int mLastPosition = -1;
    private boolean mOpenAnimationEnable = true;
    private final DataSetObservable mDataSetObservable = new DataSetObservable();

    public BaseRecyclerAdapter() {
        this.setHasStableIds(false);
        this.mList = new ArrayList<T>();
    }

    public BaseRecyclerAdapter(Collection<T> collection) {
        this.setHasStableIds(false);
        this.mList = new ArrayList<T>(collection);
    }

    private void addAnimate(V holder, int position) {
        if (this.mOpenAnimationEnable && this.mLastPosition < position) {
            ((RecyclerView.ViewHolder)holder).itemView.setAlpha(0.0f);
            ((RecyclerView.ViewHolder)holder).itemView.animate().alpha(1.0f).start();
            this.mLastPosition = position;
        }
    }

    protected View getInflate(ViewGroup parent, @LayoutRes int layoutId) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
    }

    public void onBindViewHolder(@NonNull V holder, int position) {
        if (this.getItem(position) != null) {
            this.onBindViewHolder(holder, this.getItem(position), position);
        }
    }

    protected abstract void onBindViewHolder(V var1, T var2, int var3);

    public int getItemCount() {
        return this.mList.size();
    }

    public void onViewAttachedToWindow(@NonNull V holder) {
        super.onViewAttachedToWindow(holder);
        this.addAnimate(holder, holder.getLayoutPosition());
    }

    public void setOpenAnimationEnable(boolean enabled) {
        this.mOpenAnimationEnable = enabled;
    }

    public BaseRecyclerAdapter refresh(Collection<T> collection) {
        if (collection != null) {
            this.mList.clear();
            this.mList.addAll(collection);
            this.notifyChanged();
            this.mLastPosition = -1;
        }
        return this;
    }

    public BaseRecyclerAdapter loadMore(Collection<T> collection) {
        if (collection != null) {
            this.mList.addAll(collection);
            this.notifyChanged();
        }
        return this;
    }

    public BaseRecyclerAdapter load(T item) {
        if (item != null) {
            this.mList.add(item);
            this.notifyChanged();
        }
        return this;
    }

    private void notifyChanged() {
        this.notifyDataSetChanged();
        this.notifyListDataSetChanged();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public void notifyListDataSetChanged() {
        this.mDataSetObservable.notifyChanged();
    }

    public void notifyDataSetInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        RecyclerView.ViewHolder holder;
        if (convertView != null) {
            holder = (RecyclerView.ViewHolder)convertView.getTag();
        } else {
            holder = this.onCreateViewHolder(parent, this.getItemViewType(position));
            convertView = holder.itemView;
            convertView.setTag((Object)holder);
        }
        this.onBindViewHolder(holder, position);
        this.addAnimate(holder, position);
        return convertView;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public T getItem(int position) {
        return position < this.getCount() ? (T)this.mList.get(position) : null;
    }

    public int getCount() {
        return this.mList != null ? this.mList.size() : 0;
    }

    public void replace(int position, T item) {
        if (position > -1 && position < this.mList.size() && item != null) {
            this.mList.set(position, item);
            this.notifyDataSetChanged();
        }
    }

    public void replaceNotNotify(int position, T item) {
        if (position > -1 && position < this.mList.size() && item != null) {
            this.mList.set(position, item);
        }
    }

    public List<T> getListData() {
        return this.mList;
    }

    public int getLastPosition() {
        return this.mLastPosition;
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.mList.clear();
        }
    }
}

