/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.model.GeneralResult;
import com.baidu.ocr.sdk.model.WordSimple;
import com.baidu.ocr.sdk.utils.Parser;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeneralSimpleResultParser
implements Parser<GeneralResult> {
    @Override
    public GeneralResult parse(String json) throws OCRError {
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("error_code")) {
                OCRError error = new OCRError(jsonObject.optInt("error_code"), jsonObject.optString("error_msg"));
                error.setLogId(jsonObject.optLong("log_id"));
                throw error;
            }
            GeneralResult result = new GeneralResult();
            result.setLogId(jsonObject.optLong("log_id"));
            result.setJsonRes(json);
            result.setDirection(jsonObject.optInt("direction", -1));
            result.setWordsResultNumber(jsonObject.optInt("words_result_num"));
            JSONArray wordsArray = jsonObject.optJSONArray("words_result");
            int wordsArrayCount = wordsArray == null ? 0 : wordsArray.length();
            ArrayList<WordSimple> wordList = new ArrayList<WordSimple>();
            for (int i = 0; i < wordsArrayCount; ++i) {
                JSONObject wordObject = wordsArray.optJSONObject(i);
                WordSimple word = new WordSimple();
                word.setWords(wordObject.optString("words"));
                wordList.add(word);
            }
            result.setWordList(wordList);
            return result;
        }
        catch (JSONException e) {
            OCRError error = new OCRError(283505, "Server illegal response " + json, e);
            throw error;
        }
    }
}

