/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.model.BankCardResult;
import com.baidu.ocr.sdk.utils.Parser;
import org.json.JSONException;
import org.json.JSONObject;

public class BankCardResultParser
implements Parser<BankCardResult> {
    @Override
    public BankCardResult parse(String json) throws OCRError {
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("error_code")) {
                OCRError error = new OCRError(jsonObject.optInt("error_code"), jsonObject.optString("error_msg"));
                error.setLogId(jsonObject.optLong("log_id"));
                throw error;
            }
            BankCardResult result = new BankCardResult();
            result.setLogId(jsonObject.optLong("log_id"));
            result.setJsonRes(json);
            JSONObject resultObject = jsonObject.optJSONObject("result");
            if (resultObject != null) {
                result.setBankCardNumber(resultObject.optString("bank_card_number"));
                result.setBankCardType(resultObject.optInt("bank_card_type"));
                result.setBankName(resultObject.optString("bank_name"));
            }
            return result;
        }
        catch (JSONException e) {
            throw new OCRError(283505, "Server illegal response " + json, e);
        }
    }
}

