/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.model.GeneralResult;
import com.baidu.ocr.sdk.model.VertexesLocation;
import com.baidu.ocr.sdk.model.Word;
import com.baidu.ocr.sdk.utils.Parser;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeneralResultParser
implements Parser<GeneralResult> {
    @Override
    public GeneralResult parse(String json) throws OCRError {
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("error_code") && jsonObject.getInt("error_code") != 0) {
                OCRError error = new OCRError(jsonObject.optInt("error_code"), jsonObject.optString("error_msg"));
                error.setLogId(jsonObject.optLong("log_id"));
                throw error;
            }
            GeneralResult result = new GeneralResult();
            result.setLogId(jsonObject.optLong("log_id"));
            result.setJsonRes(json);
            result.setDirection(jsonObject.optInt("direction", -1));
            result.setWordsResultNumber(jsonObject.optInt("words_result_num"));
            JSONArray wordsArray = jsonObject.optJSONArray("words_result");
            int wordsArrayCount = wordsArray == null ? 0 : wordsArray.length();
            ArrayList<Word> wordList = new ArrayList<Word>();
            for (int i = 0; i < wordsArrayCount; ++i) {
                JSONArray charArray;
                JSONObject wordObject = wordsArray.optJSONObject(i);
                JSONObject locationObject = wordObject.optJSONObject("location");
                Word word = new Word();
                word.getLocation().setLeft(locationObject.optInt("left"));
                word.getLocation().setTop(locationObject.optInt("top"));
                word.getLocation().setWidth(locationObject.optInt("width"));
                word.getLocation().setHeight(locationObject.optInt("height"));
                word.setWords(wordObject.optString("words"));
                wordList.add(word);
                JSONArray vertexesLocationArray = wordObject.optJSONArray("vertexes_location");
                if (vertexesLocationArray != null) {
                    ArrayList<VertexesLocation> vertexesLocations = new ArrayList<VertexesLocation>();
                    for (int j = 0; j < vertexesLocationArray.length(); ++j) {
                        JSONObject vertexesLocationObject = vertexesLocationArray.optJSONObject(j);
                        VertexesLocation vertexesLocation = new VertexesLocation();
                        vertexesLocation.setX(vertexesLocationObject.optInt("x"));
                        vertexesLocation.setY(vertexesLocationObject.optInt("y"));
                        vertexesLocations.add(vertexesLocation);
                    }
                    word.setVertexesLocations(vertexesLocations);
                }
                if ((charArray = wordObject.optJSONArray("chars")) == null) continue;
                ArrayList<Word.Char> charList = new ArrayList<Word.Char>();
                for (int j = 0; j < charArray.length(); ++j) {
                    JSONObject charObject = charArray.optJSONObject(j);
                    JSONObject location = charObject.optJSONObject("location");
                    Word.Char characterResult = new Word.Char();
                    characterResult.getLocation().setLeft(location.optInt("left"));
                    characterResult.getLocation().setTop(location.optInt("top"));
                    characterResult.getLocation().setWidth(location.optInt("width"));
                    characterResult.getLocation().setHeight(location.optInt("height"));
                    characterResult.setCharacter(charObject.optString("char"));
                    charList.add(characterResult);
                }
                word.setCharacterResults(charList);
            }
            result.setWordList(wordList);
            return result;
        }
        catch (JSONException e) {
            OCRError error = new OCRError(283505, "Server illegal response " + json, e);
            throw error;
        }
    }
}

