/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.baidu.ocr.sdk.OnResultListener;
import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.exception.SDKError;
import com.baidu.ocr.sdk.jni.JniInterface;
import com.baidu.ocr.sdk.model.AccessToken;
import com.baidu.ocr.sdk.model.BankCardParams;
import com.baidu.ocr.sdk.model.BankCardResult;
import com.baidu.ocr.sdk.model.GeneralBasicParams;
import com.baidu.ocr.sdk.model.GeneralParams;
import com.baidu.ocr.sdk.model.GeneralResult;
import com.baidu.ocr.sdk.model.IDCardParams;
import com.baidu.ocr.sdk.model.IDCardResult;
import com.baidu.ocr.sdk.model.OcrRequestParams;
import com.baidu.ocr.sdk.model.OcrResponseResult;
import com.baidu.ocr.sdk.utils.AccessTokenParser;
import com.baidu.ocr.sdk.utils.BankCardResultParser;
import com.baidu.ocr.sdk.utils.CrashReporterHandler;
import com.baidu.ocr.sdk.utils.DeviceUtil;
import com.baidu.ocr.sdk.utils.GeneralResultParser;
import com.baidu.ocr.sdk.utils.GeneralSimpleResultParser;
import com.baidu.ocr.sdk.utils.HttpUtil;
import com.baidu.ocr.sdk.utils.IDCardResultParser;
import com.baidu.ocr.sdk.utils.ImageUtil;
import com.baidu.ocr.sdk.utils.OcrResultParser;
import com.baidu.ocr.sdk.utils.Util;
import java.io.File;

public class OCR {
    public static final String OCR_SDK_VERSION = "1_4_4";
    private static final String RECOGNIZE_GENERAL_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/general?";
    private static final String RECOGNIZE_GENERAL_BASIC_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic?";
    private static final String RECOGNIZE_ACCURATE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate?";
    private static final String RECOGNIZE_ACCURATE_BASIC_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic?";
    private static final String RECOGNIZE_GENERAL_ENHANCE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/general_enhanced?";
    private static final String RECOGNIZE_GENERAL_WEBIMAGE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/webimage?";
    private static final String RECOGNIZE_VEHICLE_LICENSE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_license?";
    private static final String RECOGNIZE_DRIVING_LICENSE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/driving_license?";
    private static final String RECOGNIZE_LICENSE_PLATE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/license_plate?";
    private static final String RECOGNIZE_BUSINESS_LICENSE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/business_license?";
    private static final String RECOGNIZE_RECEIPT_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/receipt?";
    private static final String RECOGNIZE_VAT_INVOICE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice?";
    private static final String RECOGNIZE_TAXI_RECEIPT_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/taxi_receipt?";
    private static final String RECOGNIZE_VIN_CODE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/vin_code?";
    private static final String RECOGNIZE_TRAIN_TICKET_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/train_ticket?";
    private static final String RECOGNIZE_HANDWRITING_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/handwriting?";
    private static final String RECOGNIZE_QRCODE_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/qrcode?";
    private static final String RECOGNIZE_NUMBERS_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/numbers?";
    private static final String RECOGNIZE_PASSPORT_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/passport?";
    private static final String RECOGNIZE_LOTTERY_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/lottery?";
    private static final String RECOGNIZE_BUSINESS_CARD_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/business_card?";
    private static final String RECOGNIZE_CUSTOM = "https://aip.baidubce.com/rest/2.0/solution/v1/iocr/recognise?";
    private static final String ID_CARD_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/idcard?";
    private static final String BANK_CARD_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/bankcard?";
    private static final String QUERY_TOKEN = "https://verify.baidubce.com/verify/1.0/token/sk?sdkVersion=1_4_4";
    private static final String QUERY_TOKEN_BIN = "https://verify.baidubce.com/verify/1.0/token/bin?sdkVersion=1_4_4";
    private static final String PREFRENCE_FILE_KEY = "com.baidu.ocr.sdk";
    private static final String PREFRENCE_TOKENJSON_KEY = "token_json";
    private static final String PREFRENCE_EXPIRETIME_KEY = "token_expire_time";
    private static final String PREFRENCE_AUTH_TYPE = "token_auth_type";
    private static final int IMAGE_MAX_WIDTH = 1280;
    private static final int IMAGE_MAX_HEIGHT = 1280;
    private AccessToken accessToken = null;
    private static final int AUTHWITH_NOTYET = 0;
    private static final int AUTHWITH_LICENSE = 1;
    private static final int AUTHWITH_AKSK = 2;
    private static final int AUTHWITH_TOKEN = 3;
    private int authStatus = 0;
    private String ak = null;
    private String sk = null;
    private boolean isAutoCacheToken = false;
    private String license = null;
    @SuppressLint(value={"StaticFieldLeak"})
    private Context context;
    private CrashReporterHandler crInst;
    private static volatile OCR instance;

    public boolean isAutoCacheToken() {
        return this.isAutoCacheToken;
    }

    public void setAutoCacheToken(boolean autoCacheToken) {
        this.isAutoCacheToken = autoCacheToken;
    }

    private OCR(Context ctx) {
        if (ctx != null) {
            this.context = ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OCR getInstance(Context ctx) {
        if (instance != null) return instance;
        Class<OCR> clazz = OCR.class;
        synchronized (OCR.class) {
            if (instance != null) return instance;
            instance = new OCR(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        this.context = context;
        this.crInst = CrashReporterHandler.init(context).addSourceClass(OCR.class);
        try {
            Class<?> uiClass = Class.forName("com.baidu.ocr.ui.camera.CameraActivity");
            this.crInst.addSourceClass(uiClass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HttpUtil.getInstance().init();
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public synchronized void setAccessToken(AccessToken accessToken) {
        if (accessToken.getTokenJson() != null) {
            SharedPreferences mSharedPreferences = this.context.getSharedPreferences(PREFRENCE_FILE_KEY, 0);
            SharedPreferences.Editor editor = mSharedPreferences.edit();
            editor.putString(PREFRENCE_TOKENJSON_KEY, accessToken.getTokenJson());
            editor.putLong(PREFRENCE_EXPIRETIME_KEY, accessToken.getExpiresTime());
            editor.putInt(PREFRENCE_AUTH_TYPE, this.authStatus);
            editor.apply();
        }
        this.accessToken = accessToken;
    }

    public synchronized AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void recognizeGeneral(GeneralParams param, OnResultListener<GeneralResult> listener) {
        this.recognizeLocation(param, listener, RECOGNIZE_GENERAL_URL);
    }

    public void recognizeAccurate(GeneralParams param, OnResultListener<GeneralResult> listener) {
        this.recognizeLocation(param, listener, RECOGNIZE_ACCURATE_URL);
    }

    private void recognizeLocation(final GeneralParams param, final OnResultListener<GeneralResult> listener, final String url) {
        File imageFile = param.getImageFile();
        final File tempImage = new File(this.context.getCacheDir(), String.valueOf(System.currentTimeMillis()));
        ImageUtil.resize(imageFile.getAbsolutePath(), tempImage.getAbsolutePath(), 1280, 1280);
        param.setImageFile(tempImage);
        final GeneralResultParser generalResultParser = new GeneralResultParser();
        this.getToken(new OnResultListener(){

            public void onResult(Object result) {
                HttpUtil.getInstance().post(OCR.this.urlAppendCommonParams(url), param, generalResultParser, new OnResultListener<GeneralResult>(){

                    @Override
                    public void onResult(GeneralResult result) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onResult(result);
                        }
                    }

                    @Override
                    public void onError(OCRError error) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }
                });
            }

            @Override
            public void onError(OCRError error) {
                listener.onError(error);
            }
        });
    }

    public void recognizeGeneralBasic(GeneralBasicParams param, OnResultListener<GeneralResult> listener) {
        this.recognizeNoLocation(param, listener, RECOGNIZE_GENERAL_BASIC_URL);
    }

    public void recognizeAccurateBasic(GeneralBasicParams param, OnResultListener<GeneralResult> listener) {
        this.recognizeNoLocation(param, listener, RECOGNIZE_ACCURATE_BASIC_URL);
    }

    public void recognizeGeneralEnhanced(GeneralBasicParams param, OnResultListener<GeneralResult> listener) {
        this.recognizeNoLocation(param, listener, RECOGNIZE_GENERAL_ENHANCE_URL);
    }

    public void recognizeWebimage(GeneralBasicParams param, OnResultListener<GeneralResult> listener) {
        this.recognizeNoLocation(param, listener, RECOGNIZE_GENERAL_WEBIMAGE_URL);
    }

    private void recognizeNoLocation(final GeneralBasicParams param, final OnResultListener<GeneralResult> listener, final String url) {
        File imageFile = param.getImageFile();
        final File tempImage = new File(this.context.getCacheDir(), String.valueOf(System.currentTimeMillis()));
        ImageUtil.resize(imageFile.getAbsolutePath(), tempImage.getAbsolutePath(), 1280, 1280);
        param.setImageFile(tempImage);
        final GeneralSimpleResultParser generalSimpleResultParser = new GeneralSimpleResultParser();
        this.getToken(new OnResultListener(){

            public void onResult(Object result) {
                HttpUtil.getInstance().post(OCR.this.urlAppendCommonParams(url), param, generalSimpleResultParser, new OnResultListener<GeneralResult>(){

                    @Override
                    public void onResult(GeneralResult result) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onResult(result);
                        }
                    }

                    @Override
                    public void onError(OCRError error) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }
                });
            }

            @Override
            public void onError(OCRError error) {
                listener.onError(error);
            }
        });
    }

    public void recognizeIDCard(final IDCardParams param, final OnResultListener<IDCardResult> listener) {
        File imageFile = param.getImageFile();
        final File tempImage = new File(this.context.getCacheDir(), String.valueOf(System.currentTimeMillis()));
        ImageUtil.resize(imageFile.getAbsolutePath(), tempImage.getAbsolutePath(), 1280, 1280, param.getImageQuality());
        param.setImageFile(tempImage);
        final IDCardResultParser idCardResultParser = new IDCardResultParser(param.getIdCardSide());
        this.getToken(new OnResultListener(){

            public void onResult(Object result) {
                HttpUtil.getInstance().post(OCR.this.urlAppendCommonParams(OCR.ID_CARD_URL), param, idCardResultParser, new OnResultListener<IDCardResult>(){

                    @Override
                    public void onResult(IDCardResult result) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onResult(result);
                        }
                    }

                    @Override
                    public void onError(OCRError error) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }
                });
            }

            @Override
            public void onError(OCRError error) {
                listener.onError(error);
            }
        });
    }

    public void recognizeBankCard(final BankCardParams params, final OnResultListener<BankCardResult> listener) {
        File imageFile = params.getImageFile();
        final File tempImage = new File(this.context.getCacheDir(), String.valueOf(System.currentTimeMillis()));
        ImageUtil.resize(imageFile.getAbsolutePath(), tempImage.getAbsolutePath(), 1280, 1280);
        params.setImageFile(tempImage);
        final BankCardResultParser bankCardResultParser = new BankCardResultParser();
        this.getToken(new OnResultListener(){

            public void onResult(Object result) {
                HttpUtil.getInstance().post(OCR.this.urlAppendCommonParams(OCR.BANK_CARD_URL), params, bankCardResultParser, new OnResultListener<BankCardResult>(){

                    @Override
                    public void onResult(BankCardResult result) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onResult(result);
                        }
                    }

                    @Override
                    public void onError(OCRError error) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }
                });
            }

            @Override
            public void onError(OCRError error) {
                listener.onError(error);
            }
        });
    }

    public void recognizeVehicleLicense(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_VEHICLE_LICENSE_URL);
    }

    public void recognizeDrivingLicense(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_DRIVING_LICENSE_URL);
    }

    public void recognizeLicensePlate(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_LICENSE_PLATE_URL);
    }

    public void recognizeBusinessLicense(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_BUSINESS_LICENSE_URL);
    }

    public void recognizeReceipt(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_RECEIPT_URL);
    }

    public void recognizeVatInvoice(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_VAT_INVOICE_URL);
    }

    public void recognizeTaxireceipt(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_TAXI_RECEIPT_URL);
    }

    public void recognizeVincode(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_VIN_CODE_URL);
    }

    public void recognizeTrainticket(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_TRAIN_TICKET_URL);
    }

    public void recognizeHandwriting(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_HANDWRITING_URL);
    }

    public void recognizeQrcode(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_QRCODE_URL);
    }

    public void recognizeNumbers(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_NUMBERS_URL);
    }

    public void recognizePassport(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_PASSPORT_URL);
    }

    public void recognizeLottery(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_LOTTERY_URL);
    }

    public void recognizeBusinessCard(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_BUSINESS_CARD_URL);
    }

    public void recognizeCustom(OcrRequestParams params, OnResultListener<OcrResponseResult> listener) {
        this.recognizeCommon(params, listener, RECOGNIZE_CUSTOM);
    }

    public void recognizeCommon(final OcrRequestParams params, final OnResultListener<OcrResponseResult> listener, final String url) {
        File imageFile = params.getImageFile();
        final File tempImage = new File(this.context.getCacheDir(), String.valueOf(System.currentTimeMillis()));
        ImageUtil.resize(imageFile.getAbsolutePath(), tempImage.getAbsolutePath(), 1280, 1280);
        params.setImageFile(tempImage);
        final OcrResultParser ocrResultParser = new OcrResultParser();
        this.getToken(new OnResultListener(){

            public void onResult(Object result) {
                HttpUtil.getInstance().post(OCR.this.urlAppendCommonParams(url), params, ocrResultParser, new OnResultListener<OcrResponseResult>(){

                    @Override
                    public void onResult(OcrResponseResult result) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onResult(result);
                        }
                    }

                    @Override
                    public void onError(OCRError error) {
                        tempImage.delete();
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }
                });
            }

            @Override
            public void onError(OCRError error) {
                listener.onError(error);
            }
        });
    }

    @Deprecated
    public void initWithToken(Context context, AccessToken token) {
        this.init(context);
        this.setAccessToken(token);
    }

    public void initAccessTokenWithAkSk(OnResultListener<AccessToken> listener, Context context, String ak, String sk) {
        this.authStatus = 2;
        this.ak = ak;
        this.sk = sk;
        this.init(context);
        AccessToken tokenFromCache = this.getByCache();
        if (tokenFromCache != null) {
            this.accessToken = tokenFromCache;
            listener.onResult(tokenFromCache);
            this.setLicense(tokenFromCache.getLic());
            return;
        }
        Throwable loadLibError = JniInterface.getLoadLibraryError();
        if (loadLibError != null) {
            SDKError e = new SDKError(283506, "Load jni so library error", loadLibError);
            listener.onError(e);
            return;
        }
        JniInterface jniInterface = new JniInterface();
        String hashSk = Util.md5(sk);
        byte[] buf = jniInterface.init(context, DeviceUtil.getDeviceInfo(context));
        String param = ak + ";" + hashSk + Base64.encodeToString((byte[])buf, (int)2);
        HttpUtil.getInstance().getAccessToken(listener, QUERY_TOKEN, param);
    }

    public String getLicense() {
        JniInterface jniInterface = new JniInterface();
        if (this.authStatus == 1) {
            return jniInterface.getToken(this.context);
        }
        if (this.authStatus == 2 && this.license != null) {
            try {
                byte[] bin = Base64.decode((String)this.license, (int)0);
                String ret = jniInterface.getTokenFromLicense(this.context, bin, bin.length);
                return ret;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public void initAccessToken(OnResultListener<AccessToken> listener, Context context) {
        this.initAccessTokenImpl(listener, null, context);
    }

    public void initAccessToken(OnResultListener<AccessToken> listener, String licenseFile, Context context) {
        this.initAccessTokenImpl(listener, licenseFile, context);
    }

    private void initAccessTokenImpl(OnResultListener<AccessToken> listener, String licenseFile, Context context) {
        this.authStatus = 1;
        this.init(context);
        Throwable loadLibError = JniInterface.getLoadLibraryError();
        if (loadLibError != null) {
            SDKError e = new SDKError(283506, "Load jni so library error", loadLibError);
            listener.onError(e);
            return;
        }
        JniInterface jniInterface = new JniInterface();
        try {
            byte[] buf = licenseFile == null ? jniInterface.initWithBin(context, DeviceUtil.getDeviceInfo(context)) : jniInterface.initWithBinLic(context, DeviceUtil.getDeviceInfo(context), licenseFile);
            String param = Base64.encodeToString((byte[])buf, (int)2);
            AccessToken tokenFromCache = this.getByCache();
            if (tokenFromCache != null) {
                this.accessToken = tokenFromCache;
                listener.onResult(tokenFromCache);
            } else {
                HttpUtil.getInstance().getAccessToken(listener, QUERY_TOKEN_BIN, param);
            }
        }
        catch (OCRError ocrError) {
            listener.onError(ocrError);
        }
    }

    private AccessToken getByCache() {
        if (!this.isAutoCacheToken) {
            return null;
        }
        SharedPreferences mSharedPreferences = this.context.getSharedPreferences(PREFRENCE_FILE_KEY, 0);
        String json = mSharedPreferences.getString(PREFRENCE_TOKENJSON_KEY, "");
        int type = mSharedPreferences.getInt(PREFRENCE_AUTH_TYPE, 0);
        if (type != this.authStatus) {
            SharedPreferences.Editor editor = mSharedPreferences.edit();
            editor.clear();
            editor.commit();
            return null;
        }
        AccessTokenParser parser = new AccessTokenParser();
        try {
            AccessToken token = parser.parse(json);
            long expireTime = mSharedPreferences.getLong(PREFRENCE_EXPIRETIME_KEY, 0L);
            token.setExpireTime(expireTime);
            this.authStatus = type;
            return token;
        }
        catch (SDKError sdkError) {
            return null;
        }
    }

    private synchronized boolean isTokenInvalid() {
        return null == this.accessToken || this.accessToken.hasExpired();
    }

    private void getToken(final OnResultListener listener) {
        if (this.isTokenInvalid()) {
            if (this.authStatus == 2) {
                this.initAccessTokenWithAkSk(new OnResultListener<AccessToken>(){

                    @Override
                    public void onResult(AccessToken result) {
                        OCR.this.setAccessToken(result);
                        listener.onResult(result);
                    }

                    @Override
                    public void onError(OCRError error) {
                        listener.onError(error);
                    }
                }, this.context, this.ak, this.sk);
            }
            if (this.authStatus == 1) {
                this.initAccessToken(new OnResultListener<AccessToken>(){

                    @Override
                    public void onResult(AccessToken result) {
                        OCR.this.setAccessToken(result);
                        listener.onResult(result);
                    }

                    @Override
                    public void onError(OCRError error) {
                        listener.onError(error);
                    }
                }, this.context);
            }
        } else {
            listener.onResult(this.accessToken);
        }
    }

    private String urlAppendCommonParams(String url) {
        StringBuilder sb = new StringBuilder(url);
        sb.append("access_token=").append(this.getAccessToken().getAccessToken());
        sb.append("&aipSdk=Android");
        sb.append("&aipSdkVersion=").append(OCR_SDK_VERSION);
        sb.append("&aipDevid=").append(DeviceUtil.getDeviceId(this.context));
        return sb.toString();
    }

    public void release() {
        HttpUtil.getInstance().release();
        this.crInst.release();
        this.crInst = null;
        this.context = null;
        if (instance != null) {
            instance = null;
        }
    }
}

