/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.json.JSONException;

public class NetUtil {
    private static final String TAG = "NetUtil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void uploadData(RequestAdapter<T> adapter) {
        boolean requireRetry = false;
        int retryCount = adapter.getRetryCount();
        int code = 0;
        Throwable exception = null;
        Object result = null;
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;
        do {
            try {
                requireRetry = false;
                code = 0;
                exception = null;
                result = null;
                URL url = new URL(adapter.getURL());
                conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(adapter.getConnectTimeout());
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setReadTimeout(adapter.getReadTimeout());
                conn.setRequestMethod(adapter.getRequestMethod());
                conn.setUseCaches(false);
                out = conn.getOutputStream();
                out.write(adapter.getRequestString().getBytes("UTF-8"));
                out.flush();
                if (conn.getResponseCode() != 200) {
                    code = 4;
                    exception = new IllegalStateException("ResponseCode: " + conn.getResponseCode());
                    continue;
                }
                in = conn.getInputStream();
                result = adapter.parseResponse(in);
            }
            catch (SocketTimeoutException e) {
                e.printStackTrace();
                requireRetry = true;
                code = 1;
                exception = e;
            }
            catch (IOException e) {
                e.printStackTrace();
                code = 2;
                exception = e;
            }
            catch (JSONException e) {
                e.printStackTrace();
                code = 3;
                exception = e;
            }
            catch (Exception e) {
                e.printStackTrace();
                code = 5;
                exception = e;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        } while (requireRetry && retryCount-- > 0);
        adapter.onResponse(code, result, (Exception)exception);
    }

    public static boolean isConnected(Context app) {
        ConnectivityManager connectivityManager = (ConnectivityManager)app.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        if (activeNetworkInfo == null) {
            return false;
        }
        return activeNetworkInfo.isConnected();
    }

    private NetUtil() {
        throw new RuntimeException("This class instance can not be created.");
    }

    public static abstract class RequestAdapter<T> {
        public static final int RESPONSE_STATUS_NORMAL = 0;
        public static final int RESPONSE_STATUS_ERROR_TIMEOUT = 1;
        public static final int RESPONSE_STATUS_ERROR_IO = 2;
        public static final int RESPONSE_STATUS_ERROR_PARSE_JSON = 3;
        public static final int RESPONSE_STATUS_ERROR_RESPONSE_CODE = 4;
        public static final int RESPONSE_STATUS_ERROR_UNKNOWN = 5;
        private static final int RETRY_COUNT = 2;
        private static final int CONNECT_TIMEOUT = 5000;
        private static final int READ_TIMEOUT = 5000;
        private static final String REQUEST_METHOD = "POST";

        public abstract String getURL();

        public abstract String getRequestString();

        public abstract T parseResponse(InputStream var1) throws IOException, JSONException;

        public abstract void onResponse(int var1, T var2, Exception var3);

        public int getRetryCount() {
            return 2;
        }

        public int getConnectTimeout() {
            return 5000;
        }

        public int getReadTimeout() {
            return 5000;
        }

        public String getRequestMethod() {
            return REQUEST_METHOD;
        }
    }
}

