/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.exception;

public class OCRError
extends Exception {
    protected int errorCode;
    protected long logId;
    protected String errorMessage;
    protected Throwable cause;

    public OCRError(int errorCode, String message, Throwable cause) {
        super(OCRError.genMessage(errorCode, message), cause);
        this.cause = cause;
        this.errorCode = errorCode;
    }

    public OCRError(int errorCode, String message) {
        super(OCRError.genMessage(errorCode, message));
        this.errorCode = errorCode;
        this.errorMessage = message;
    }

    public OCRError(String message) {
        super(message);
    }

    public OCRError() {
    }

    private static String genMessage(int code, String message) {
        return "[" + code + "] " + message;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getLogId() {
        return this.logId;
    }

    public void setLogId(long logId) {
        this.logId = logId;
    }

    public static interface ErrorCode {
        public static final int SERVICE_DATA_ERROR = 283505;
    }
}

