/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.ArrowDrawable;
import com.scwang.smartrefresh.layout.internal.InternalClassics;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class ClassicsFooter
extends InternalClassics<ClassicsFooter>
implements RefreshFooter {
    public static String REFRESH_FOOTER_PULLING = null;
    public static String REFRESH_FOOTER_RELEASE = null;
    public static String REFRESH_FOOTER_LOADING = null;
    public static String REFRESH_FOOTER_REFRESHING = null;
    public static String REFRESH_FOOTER_FINISH = null;
    public static String REFRESH_FOOTER_FAILED = null;
    public static String REFRESH_FOOTER_NOTHING = null;
    protected boolean mNoMoreData = false;

    public ClassicsFooter(Context context) {
        this(context, null);
    }

    public ClassicsFooter(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClassicsFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (REFRESH_FOOTER_PULLING == null) {
            REFRESH_FOOTER_PULLING = context.getString(R.string.srl_footer_pulling);
        }
        if (REFRESH_FOOTER_RELEASE == null) {
            REFRESH_FOOTER_RELEASE = context.getString(R.string.srl_footer_release);
        }
        if (REFRESH_FOOTER_LOADING == null) {
            REFRESH_FOOTER_LOADING = context.getString(R.string.srl_footer_loading);
        }
        if (REFRESH_FOOTER_REFRESHING == null) {
            REFRESH_FOOTER_REFRESHING = context.getString(R.string.srl_footer_refreshing);
        }
        if (REFRESH_FOOTER_FINISH == null) {
            REFRESH_FOOTER_FINISH = context.getString(R.string.srl_footer_finish);
        }
        if (REFRESH_FOOTER_FAILED == null) {
            REFRESH_FOOTER_FAILED = context.getString(R.string.srl_footer_failed);
        }
        if (REFRESH_FOOTER_NOTHING == null) {
            REFRESH_FOOTER_NOTHING = context.getString(R.string.srl_footer_nothing);
        }
        ClassicsFooter thisView = this;
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        DensityUtil density = new DensityUtil();
        this.mTitleText.setTextColor(-10066330);
        this.mTitleText.setText((CharSequence)(thisView.isInEditMode() ? REFRESH_FOOTER_LOADING : REFRESH_FOOTER_PULLING));
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClassicsFooter);
        RelativeLayout.LayoutParams lpArrow = (RelativeLayout.LayoutParams)arrowView.getLayoutParams();
        RelativeLayout.LayoutParams lpProgress = (RelativeLayout.LayoutParams)progressView.getLayoutParams();
        lpArrow.rightMargin = lpProgress.rightMargin = ta.getDimensionPixelSize(R.styleable.ClassicsFooter_srlDrawableMarginRight, density.dip2px(20.0f));
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableArrowSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableArrowSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableProgressSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableProgressSize, lpProgress.height);
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsFooter_srlDrawableSize, lpProgress.height);
        this.mFinishDuration = ta.getInt(R.styleable.ClassicsFooter_srlFinishDuration, this.mFinishDuration);
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.ClassicsFooter_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        if (ta.hasValue(R.styleable.ClassicsFooter_srlDrawableArrow)) {
            this.mArrowView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsFooter_srlDrawableArrow));
        } else {
            this.mArrowDrawable = new ArrowDrawable();
            this.mArrowDrawable.setColor(-10066330);
            this.mArrowView.setImageDrawable((Drawable)this.mArrowDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlDrawableProgress)) {
            this.mProgressView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsFooter_srlDrawableProgress));
        } else {
            this.mProgressDrawable = new ProgressDrawable();
            this.mProgressDrawable.setColor(-10066330);
            this.mProgressView.setImageDrawable((Drawable)this.mProgressDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlTextSizeTitle)) {
            this.mTitleText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsFooter_srlTextSizeTitle, DensityUtil.dp2px(16.0f)));
        } else {
            this.mTitleText.setTextSize(16.0f);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlPrimaryColor)) {
            this.setPrimaryColor(ta.getColor(R.styleable.ClassicsFooter_srlPrimaryColor, 0));
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlAccentColor)) {
            this.setAccentColor(ta.getColor(R.styleable.ClassicsFooter_srlAccentColor, 0));
        }
        ta.recycle();
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        if (!this.mNoMoreData) {
            super.onStartAnimator(refreshLayout, height, maxDragHeight);
        }
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (!this.mNoMoreData) {
            this.mTitleText.setText((CharSequence)(success ? REFRESH_FOOTER_FINISH : REFRESH_FOOTER_FAILED));
            return super.onFinish(layout, success);
        }
        return 0;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (this.mSpinnerStyle == SpinnerStyle.FixedBehind) {
            super.setPrimaryColors(colors);
        }
    }

    @Override
    public boolean setNoMoreData(boolean noMoreData) {
        if (this.mNoMoreData != noMoreData) {
            this.mNoMoreData = noMoreData;
            ImageView arrowView = this.mArrowView;
            if (noMoreData) {
                this.mTitleText.setText((CharSequence)REFRESH_FOOTER_NOTHING);
                arrowView.setVisibility(8);
            } else {
                this.mTitleText.setText((CharSequence)REFRESH_FOOTER_PULLING);
                arrowView.setVisibility(0);
            }
        }
        return true;
    }

    @Override
    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        ImageView arrowView = this.mArrowView;
        if (!this.mNoMoreData) {
            switch (newState) {
                case None: {
                    arrowView.setVisibility(0);
                }
                case PullUpToLoad: {
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_PULLING);
                    arrowView.animate().rotation(180.0f);
                    break;
                }
                case Loading: 
                case LoadReleased: {
                    arrowView.setVisibility(8);
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_LOADING);
                    break;
                }
                case ReleaseToLoad: {
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_RELEASE);
                    arrowView.animate().rotation(0.0f);
                    break;
                }
                case Refreshing: {
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_REFRESHING);
                    arrowView.setVisibility(8);
                }
            }
        }
    }
}

