/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

public class SmartViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private final SparseArray<View> mViews = new SparseArray();
    private final OnItemClickListener mOnItemClickListener;
    private final OnItemLongClickListener mOnItemLongClickListener;
    private int mPosition = -1;

    public SmartViewHolder(@NonNull View itemView) {
        this(itemView, null, null);
    }

    public SmartViewHolder(@NonNull View itemView, OnItemClickListener onItemClickListener, OnItemLongClickListener onItemLongClickListener) {
        super(itemView);
        this.initBackground(itemView);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mOnItemClickListener = onItemClickListener;
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    protected void initBackground(View itemView) {
        if (itemView.getBackground() == null) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = itemView.getContext().getTheme();
            int top = itemView.getPaddingTop();
            int bottom = itemView.getPaddingBottom();
            int left = itemView.getPaddingLeft();
            int right = itemView.getPaddingRight();
            if (theme.resolveAttribute(16843534, typedValue, true)) {
                itemView.setBackgroundResource(typedValue.resourceId);
            }
            itemView.setPadding(left, top, right, bottom);
        }
    }

    public void setPosition(int position) {
        this.mPosition = position;
    }

    public void onClick(View v) {
        if (this.mOnItemClickListener != null) {
            int position = this.getAdapterPosition();
            if (position >= 0) {
                this.mOnItemClickListener.onItemClick(v, position);
            } else if (this.mPosition > -1) {
                this.mOnItemClickListener.onItemClick(v, this.mPosition);
            }
        }
    }

    public boolean onLongClick(View v) {
        if (this.mOnItemLongClickListener != null) {
            int position = this.getAdapterPosition();
            if (position >= 0) {
                this.mOnItemLongClickListener.onItemLongClick(v, position);
            } else if (this.mPosition > -1) {
                this.mOnItemLongClickListener.onItemLongClick(v, this.mPosition);
            }
        }
        return true;
    }

    public <T extends View> T findViewById(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View findView(@IdRes int id) {
        return id == 0 ? this.itemView : this.findViewById(id);
    }

    public SmartViewHolder text(int id, CharSequence sequence) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).setText(sequence);
        }
        return this;
    }

    public SmartViewHolder text(@IdRes int id, @StringRes int stringRes) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).setText(stringRes);
        }
        return this;
    }

    public SmartViewHolder textColorId(@IdRes int id, @ColorRes int colorId) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)colorId));
        }
        return this;
    }

    public SmartViewHolder image(@IdRes int id, int imageId) {
        View view = this.findView(id);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageResource(imageId);
        }
        return this;
    }

    public SmartViewHolder viewClick(@IdRes int id, final OnViewItemClickListener listener, final int position) {
        View view = this.findView(id);
        if (listener != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.onViewItemClick(v, position);
                }
            });
        }
        return this;
    }

    public SmartViewHolder click(@IdRes int id, View.OnClickListener listener) {
        View view = this.findView(id);
        if (listener != null) {
            view.setOnClickListener(listener);
        }
        return this;
    }

    public SmartViewHolder visible(@IdRes int id, int visibility) {
        View view = this.findView(id);
        view.setVisibility(visibility);
        return this;
    }

    public SmartViewHolder enable(@IdRes int id, boolean enable) {
        View view = this.findView(id);
        view.setEnabled(enable);
        if (view instanceof EditText) {
            view.setFocusable(enable);
            view.setFocusableInTouchMode(enable);
        }
        return this;
    }

    public SmartViewHolder checked(@IdRes int id, boolean checked) {
        View view = this.findView(id);
        if (view instanceof CompoundButton) {
            ((CheckBox)view).setChecked(checked);
        }
        return this;
    }

    public SmartViewHolder checkedListener(@IdRes int id, CompoundButton.OnCheckedChangeListener listener) {
        View view = this.findView(id);
        if (view instanceof CompoundButton) {
            ((CheckBox)view).setOnCheckedChangeListener(listener);
        }
        return this;
    }

    public SmartViewHolder textListener(@IdRes int id, TextWatcher watcher) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).addTextChangedListener(watcher);
        }
        return this;
    }

    public SmartViewHolder backgroundResId(int viewId, int resId) {
        Object view = this.findViewById(viewId);
        view.setBackgroundResource(resId);
        return this;
    }

    public void clearViews() {
        if (this.mViews != null) {
            this.mViews.clear();
        }
    }

    public static interface OnViewItemClickListener {
        public void onViewItemClick(View var1, int var2);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(View var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

