/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.license;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.idl.authority.AuthorityState;
import com.baidu.idl.authority.IDLAuthorityException;
import com.baidu.idl.util.HttpClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class License {
    public static final String TAG = "IDL-License";
    private static final String URL = "http://sdkss.shitu.baidu.com/cgi-bin/queryLicense.py";
    private static final String LICENSE_FILE = "license";
    private static final String LICENSE_ASSETS_FILE = "idl_license";
    private static final String LICENSE_ASSETS_MULTIPLE_FILE = "license/idl_license_%s";
    private static final String LICENSE_LICENSE_FILE_NAME = "idl_license_%s";
    private static final int LICENSE_AG_ID = -1;
    private int mAuthorityStatus = 256;
    private ArrayList<String> mALLicense;
    private int mAlgorithmId = -1;
    private String mAlgorithmIdLicenseName = "";
    private static License mInstance = null;

    public static synchronized License getInstance() {
        if (null == mInstance) {
            mInstance = new License();
        }
        return mInstance;
    }

    private License() {
    }

    @Deprecated
    public int init(Context context, String apiKey) {
        this.mAlgorithmId = -1;
        this.mAlgorithmIdLicenseName = "";
        if (272 == this.mAuthorityStatus) {
            return this.mAuthorityStatus;
        }
        this.mAuthorityStatus = 272;
        this.mAuthorityStatus = this.verifyByLocalData(context, apiKey);
        Log.e((String)TAG, (String)("Local License Authority State Is :" + AuthorityState.getStateName(this.mAuthorityStatus)));
        if (this.mAuthorityStatus > 48) {
            this.mAuthorityStatus = this.verifyByNetworkData(context, apiKey);
            Log.e((String)TAG, (String)("Net License Authority State Is :" + AuthorityState.getStateName(this.mAuthorityStatus)));
        }
        if (this.mAuthorityStatus > 48) {
            Log.e((String)TAG, (String)("IDLAuthorityException :" + AuthorityState.getStateName(this.mAuthorityStatus)));
        }
        return this.mAuthorityStatus;
    }

    public int init(String aToken) {
        if (272 == this.mAuthorityStatus) {
            return this.mAuthorityStatus;
        }
        this.mAuthorityStatus = 272;
        if (null != aToken && aToken.length() > 0) {
            this.mAuthorityStatus = this.initLicenseWithToken(aToken);
            if (0 != this.mAuthorityStatus) {
                this.mAuthorityStatus = 51;
            }
        } else {
            this.mAuthorityStatus = 51;
        }
        return this.mAuthorityStatus;
    }

    private int verifyByLocalData(final Context context, final String apiKey) {
        Log.e((String)TAG, (String)"verifyByLocalData");
        int state = 49;
        this.mALLicense = this.getLocalLicense(context);
        if (null != this.mALLicense && this.mALLicense.size() > 0) {
            String[] licenses = this.mALLicense.toArray(new String[this.mALLicense.size()]);
            state = this.initLicense(context, apiKey, licenses);
            if (state == 0) {
                Log.e((String)TAG, (String)"license success.");
            } else if (state == 16) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        License.this.getLatestLicense(context, apiKey);
                    }
                }).start();
            } else {
                this.deleteErrorLicense(context);
            }
        } else {
            Log.e((String)TAG, (String)"my license is null");
        }
        return state;
    }

    private int verifyByNetworkData(Context context, String apiKey) {
        Log.e((String)TAG, (String)"verifyByNetworkData");
        int state = 240;
        this.mALLicense = this.getLicenseByNetwork(context, apiKey);
        Log.e((String)TAG, (String)("Net License:" + this.mALLicense));
        if (null != this.mALLicense && this.mALLicense.size() > 0) {
            String[] licenses = this.mALLicense.toArray(new String[this.mALLicense.size()]);
            state = this.initLicense(context, apiKey, licenses);
            if (state < 48) {
                this.WriteLicense(context, this.mALLicense);
            }
        } else {
            state = 49;
            this.deleteErrorLicense(context);
        }
        return state;
    }

    private ArrayList<String> getLocalLicense(Context context) {
        Log.e((String)TAG, (String)"getLocalLicense");
        ArrayList<String> licenses = null;
        licenses = this.ReadLicenseFromData(context);
        if (null == licenses || licenses.size() < 1) {
            licenses = this.ReadLicenseFromAsset(context);
        }
        return licenses;
    }

    private ArrayList<String> getLicenseByNetwork(Context context, String apiKey) {
        Log.e((String)TAG, (String)"getLicenseByNetwork");
        ArrayList<String> licenses = null;
        String data = this.getPostData(context, apiKey);
        Log.e((String)TAG, (String)("Network Request " + data));
        String response = HttpClient.post(URL, data);
        if (response != null && response.length() > 0) {
            Log.e((String)TAG, (String)("Network Response " + response));
        }
        int errno = -1;
        String msg = null;
        if (null == response) {
            msg = "The resopnse is null";
            return licenses;
        }
        JSONObject object = null;
        try {
            object = new JSONObject(response);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (object != null) {
            errno = object.optInt("errno", -1);
            msg = object.optString("msg");
            JSONArray json_licenses = object.optJSONArray(LICENSE_FILE);
            if (json_licenses != null && json_licenses.length() > 0) {
                licenses = new ArrayList<String>();
                for (int i = 0; i < json_licenses.length(); ++i) {
                    String tmp = json_licenses.optString(i);
                    if (tmp == null) continue;
                    licenses.add(tmp);
                }
            } else {
                errno = -1;
                msg = "There is no license in resopnse";
            }
            if (0 == errno && json_licenses != null && json_licenses.length() > 0) {
                Log.e((String)TAG, (String)"resonpse is right.");
            } else {
                licenses = null;
            }
        }
        return licenses;
    }

    private void getLatestLicense(Context context, String apiKey) {
        String[] licensesarray;
        int status;
        Log.e((String)TAG, (String)"getLatestLicense");
        ArrayList<String> licenses = null;
        licenses = this.getLicenseByNetwork(context, apiKey);
        if (null != licenses && licenses.size() > 0 && (status = this.initLicense(context, apiKey, licensesarray = licenses.toArray(new String[licenses.size()]))) < 48) {
            this.WriteLicense(context, licenses);
            Log.e((String)TAG, (String)("LatestLicense " + licenses));
        }
    }

    public ArrayList<String> ReadLicenseFromData(Context context) {
        if (context == null) {
            return null;
        }
        Log.e((String)TAG, (String)"ReadLicenseFromData");
        File file = this.getDataLicenseFile(context);
        if (file != null) {
            Log.e((String)TAG, (String)("ReadLicenseFromData file type " + file.isDirectory() + file.getAbsolutePath()));
        }
        ArrayList<String> licenses = null;
        try {
            licenses = this.analyseLicense(new FileInputStream(file));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return licenses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> ReadLicenseFromAsset(Context context) {
        Log.e((String)TAG, (String)"ReadLicenseFromAsset");
        ArrayList<String> licenses = null;
        AssetManager am = context.getAssets();
        InputStream is = null;
        try {
            is = this.getAssetsLicenseFileInputStream(am);
            if (is != null) {
                licenses = this.analyseLicense(is);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (licenses != null && licenses.size() > 0) {
            this.WriteLicense(context, licenses);
        }
        return licenses;
    }

    private ArrayList<String> analyseLicense(InputStream is) throws IOException {
        String line;
        Log.e((String)TAG, (String)"analyseLicense");
        BufferedReader br = null;
        InputStreamReader reader = null;
        reader = new InputStreamReader(is);
        br = new BufferedReader(reader);
        ArrayList<String> licenses = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            licenses.add(line);
        }
        return licenses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean WriteLicense(Context context, ArrayList<String> licenses) {
        if (licenses == null || licenses.size() == 0 || context == null) {
            return false;
        }
        Log.e((String)TAG, (String)"WriteLicense");
        boolean isSuccess = true;
        File file = this.getDataLicenseFile(context);
        if (file != null) {
            file.delete();
        }
        if (file != null || !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fout = null;
        try {
            Log.e((String)TAG, (String)("WriteLicense path " + file.getAbsolutePath()));
            fout = new FileOutputStream(file);
            for (String license : licenses) {
                fout.write(license.getBytes());
                fout.write(10);
            }
        }
        catch (FileNotFoundException e) {
            isSuccess = false;
            e.printStackTrace();
        }
        catch (IOException e) {
            isSuccess = false;
            e.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    isSuccess = false;
                    e.printStackTrace();
                }
            }
        }
        return isSuccess;
    }

    public void deleteErrorLicense(Context context) {
        if (context == null) {
            return;
        }
        Log.e((String)TAG, (String)"deleteErrorLicense");
        File file = context.getDir(LICENSE_FILE, 0);
        if (file.exists()) {
            file.delete();
        }
    }

    public int init(Context context, String apiKey, int algorithmId, String licenseName) {
        this.mAlgorithmId = algorithmId;
        this.mAlgorithmIdLicenseName = licenseName;
        int ret = this.initWithAlgorithmId(context, apiKey);
        return ret;
    }

    private int initWithAlgorithmId(Context context, String apiKey) {
        if (272 == this.mAuthorityStatus) {
            return this.mAuthorityStatus;
        }
        Log.e((String)TAG, (String)"initWithAlgorithmId");
        this.mAuthorityStatus = 272;
        this.mAuthorityStatus = this.verifyByLocalData(context, apiKey);
        Log.e((String)TAG, (String)("Local License Authority State Is :" + AuthorityState.getStateName(this.mAuthorityStatus)));
        if (this.mAuthorityStatus > 48) {
            this.mAuthorityStatus = this.verifyByNetworkData(context, apiKey);
            Log.e((String)TAG, (String)("Net License Authority State Is :" + AuthorityState.getStateName(this.mAuthorityStatus)));
        }
        if (this.mAuthorityStatus > 48) {
            throw new IDLAuthorityException(AuthorityState.getStateName(this.mAuthorityStatus));
        }
        return this.mAuthorityStatus;
    }

    public int getLicenseStateWithAlgorithmId(int algorithmId) {
        int ret = this.getLicenseState(algorithmId);
        return ret;
    }

    private File getDataLicenseFile(Context context) {
        Log.e((String)TAG, (String)"getDataLicenseFile");
        File file = null;
        if (TextUtils.isEmpty((CharSequence)this.mAlgorithmIdLicenseName)) {
            file = context.getDir(LICENSE_FILE, 0);
        } else {
            File dirFile = context.getDir(LICENSE_FILE, 0);
            if (!dirFile.exists() || !dirFile.isDirectory()) {
                dirFile.mkdirs();
            }
            String filePath = dirFile.getAbsolutePath() + File.separator + String.format(LICENSE_LICENSE_FILE_NAME, this.mAlgorithmIdLicenseName);
            file = new File(filePath);
        }
        return file;
    }

    private InputStream getAssetsLicenseFileInputStream(AssetManager am) {
        Log.e((String)TAG, (String)"getAssetsLicenseFileInputStream");
        InputStream fileInputStream = null;
        try {
            if (TextUtils.isEmpty((CharSequence)this.mAlgorithmIdLicenseName)) {
                fileInputStream = am.open(LICENSE_ASSETS_FILE);
            } else {
                String filePath = String.format(LICENSE_ASSETS_MULTIPLE_FILE, this.mAlgorithmIdLicenseName);
                fileInputStream = am.open(filePath);
            }
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"getLicenseFileInputStream error");
        }
        return fileInputStream;
    }

    public native int initLicense(Context var1, String var2, String[] var3);

    public native int initLicenseWithToken(String var1);

    public static native String getAlgorithmVersion();

    public static native String getAuthorityVersion();

    public native String getPostData(Context var1, String var2);

    public native int getLicenseState(int var1);

    public native long getLicenseRemnant(int var1);
}

